#include <iostream>
#include <iomanip>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

long long merge(double arr[], int left, int mid, int right) {
  int i = left, j = mid, k = 0;
  long long invCount = 0;
  double temp[right - left + 1];

  while ((i < mid) && (j <= right)) {
    if (arr[i] <= arr[j]) {
      temp[k] = arr[i];
      ++k;
      ++i;
    } else {
      temp[k] = arr[j];
      invCount += (mid - i);
      ++k;
      ++j;
    }
  }

  while (i < mid) {
    temp[k] = arr[i];
    ++k;
    ++i;
  }

  while (j <= right) {
    temp[k] = arr[j];
    ++k;
    ++j;
  }

  for (i = left, k = 0; i <= right; i++, k++) {
    arr[i] = temp[k];
  }

  return invCount;
}
long long mergeSort(double arr[], int left, int right) {
  long long invCount = 0;

  if (right > left) {
    int mid = (right + left) / 2;
    invCount = mergeSort(arr, left, mid);
    invCount += mergeSort(arr, mid + 1, right);
    invCount += merge(arr, left, mid + 1, right);
  }
  return invCount;
}

// Pronalazi broj inverzija niza, odnosno broj preticanja u nasem slucaju
long long getInversions(double arr[], int n) {
  return mergeSort(arr, 0, n - 1);
}

bool proveri(vector<pair<long long, long long>>& trkaci, double t, long long k)
{
    // Izracunamo poziciju trkaca posle vremena t i pronadjemo broj inverzija (preticanja)
    double poz[trkaci.size()];
    for(int i=0;i<trkaci.size();i++)
    {
        poz[i]=trkaci[i].first+t*trkaci[i].second;
    }

    long long inv=getInversions(poz,trkaci.size());
    //cout << "Broj preticanja u vremenu " << t << " je " << inv<<"\n";
    return inv>=k;
}
int main()
{
    int n;
    long long k;
    cin>>n>>k;

    vector<pair<long long,long long>> trkaci;
    for(int i=0;i<n;i++)
    {
        long long x,v;
        cin>>x>>v;
        trkaci.push_back(make_pair(x,v));
    }
    sort(trkaci.begin(),trkaci.end());

    double levo=0,desno=1e18;
    double eps=1e-5;
    while(fabs(desno-levo)>eps)
    {
        double m=(desno+levo)/2;

        //cout<<"l="<<levo<<"\n";
        //cout<<"d="<<desno<<"\n";
        //cout<<"m="<<m<<"\n";

        if(proveri(trkaci,m,k))
            desno=m;
        else
            levo=m;
    }

    cout<<fixed<<setprecision(9)<<(levo+desno)/2<<"\n";
    return 0;
}